

<?php $__env->startSection('content'); ?>
    <div class="main-content">
        <section class="section">
            <div class="section-header">
                <h1><?php echo e($pageTitle); ?></h1>
            </div>

            <div class="row">

                <div class="col-12 col-md-12 col-lg-12">
                    <div class="card">

                        <div class="card-body text-center">
                            <ul class="list-group">
                                <li class="list-group-item d-flex justify-content-between">

                                    <span class="text-right"><img src="<?php echo e(getFile('kyc', $kyc->nid)); ?>"
                                            alt="" class="w-50 "></span>

                                </li>
                               

                            </ul>
                            <div class="col-md-12 mt-4 text-left">
                               <h6><b>Full Name: </b><?php echo e($user->fname.' '.$user->lname); ?></h6>
                               <h6><b>Country: </b><?php echo e($kyc->country ?? 'N/A'); ?></h6>
                               <h6><b>Card Type: </b><?php echo e($kyc->type ?? 'N/A'); ?></h6>
                               <h6><b>Email: </b><?php echo e($user->email ?? 'N/A'); ?></h6>
                               <h6><b>Phone: </b><?php echo e($user->phone ?? 'N/A'); ?></h6>
                               <h6><b>Submit Date: </b> <?php echo e(showDateTime($kyc->created_at, 'd-m-Y')); ?> | <?php echo e(diffForHumans($kyc->created_at)); ?></h6>
                            </div>

                           

                            <?php if($kyc->status == 0): ?>
                            <div class="col-md-12 mt-4 text-right">

                                <button class="btn btn-success approve"
                                    data-url="<?php echo e(route('admin.user.kyc.status', ['approve', $kyc->id])); ?>">
                                    <i class="fa fa-check"></i>
                                    <?php echo e(__('Approve')); ?>

                                </button>


                                <button class="btn btn-danger reject"
                                    data-url="<?php echo e(route('admin.user.kyc.status', ['reject', $kyc->id])); ?>">
                                    <i class="fa fa-times"></i>
                                    <?php echo e(__('Reject')); ?>

                                </button>
                            </div>

                            <?php endif; ?>


                            



                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>

    <div class="modal fade" id="approve" tabindex="-1" role="dialog">
        <div class="modal-dialog" role="document">
            <form action="" method="post">
                <?php echo csrf_field(); ?>
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title"><?php echo e(__('KYC Request Update')); ?></h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <p><?php echo e(__('Are You Sure to Approve')); ?></p>
                    </div>
                    <div class="modal-footer">
                        <button type="submit" class="btn btn-primary"><?php echo e(__('Approve')); ?></button>
                        <button type="button" class="btn btn-secondary"
                            data-dismiss="modal">Close</button>
                    </div>
                </div>
            </form>
        </div>
    </div>

    <div class="modal fade" id="reject" tabindex="-1" role="dialog">
        <div class="modal-dialog" role="document">
            <form action="" method="post">
                <?php echo csrf_field(); ?>
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title"><?php echo e(__('KYC Request Update')); ?></h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <p><?php echo e(__('Are You Sure to Reject')); ?></p>
                    </div>
                    <div class="modal-footer">
                        <button type="submit" class="btn btn-primary"><?php echo e(__('Reject')); ?></button>
                        <button type="button" class="btn btn-secondary"
                            data-dismiss="modal">Close</button>
                    </div>
                </div>
            </form>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>

<script>
    $(function(){
        $('.approve').on('click', function(){
           const modal = $('#approve')


           modal.find('form').attr('action', $(this).data('url'))


           modal.modal('show')
        })


        $('.reject').on('click', function(){
           const modal = $('#reject')


           modal.find('form').attr('action', $(this).data('url'))


           modal.modal('show')
        })
    })
</script>
    
<?php $__env->stopPush(); ?>

<?php echo $__env->make('backend.layout.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/beacgndl/murf.beacontraders.net/core/resources/views/backend/admins/kyc/kycdetails.blade.php ENDPATH**/ ?>